// JavaScript Document

$(document).ready(function (e) {

    var formatResult;
    formatResult = function (data)
    {
        return  data.text;
    }


    $(".select2product").select2({
        placeholder: "إسم المنتج",
        minimumInputLength: document.getElementById("searchvalue").value,
        //  minimumInputLength: 3,
        multiple: false,
        quietMillis: 100,
        ajax: {
            url: "sellbillAjaxController.php?do=getProductsbyandstornoservice",
            dataType: 'json',
            data: function (term, page) {
                return {
                    term: term, //search term
                    page_limit: 10,
                    storeid: document.getElementById("storeid").value // page size

                };
            },
            results: function (data) {

                return {results: data};
            }
        },
        formatResult: formatResult,
        initSelection: function (element, callback) {
            var item = element.val().split(':');
            var data = {id: item[0], text: item[1]};
            callback(data);
        }
    });



    $("#productid").change(function ()
    {

        var theselectedvalue = $(this).val();


        getproductCurrentQuantity();


    });




});




function loadproduct()
{
    var storeid = document.getElementById("storeid").value;

    if (storeid != "-1")
    {

        document.getElementById("productbefore").value = 0;
        document.getElementById("productafter").value = 0;

        checkproductquantity();

        $("#productid").select2('val', [':اختر منتج'], true);

    }
}


function getproductCurrentQuantity()
{

    var storeid = document.getElementById("storeid").value;
    var productid = document.getElementById("productid").value;

    if (storeid != "-1" && productid != "" && productid != null)
    {

        //get store value
        $.ajax({
            url: 'settlementstoreAjaxController.php?do=getquantity&storeid=' + storeid + '&productid=' + productid,
            success: function (x) {


                document.getElementById("productbefore").value = x;
                document.getElementById("productafter").value = x;

                checkproductquantity();


            }
        });
    }
}



function checkproductquantity()
{
    var productbefore = Number(document.getElementById("productbefore").value);
    var productquantity = Number(document.getElementById("productquantity").value);
    var productafter = Number(document.getElementById("productafter").value);

    var discountvalue = document.getElementById("discountvalue").checked;
    var addvalue = document.getElementById("addvalue").checked;

    if (discountvalue == true)
    {
        if (productquantity > productbefore)
        {
            document.getElementById("productquantity").value = productbefore;
        }

        document.getElementById("productafter").value = (Number(document.getElementById("productbefore").value) - Number(document.getElementById("productquantity").value)).toFixed(3);
    }


    else if (addvalue == true)
    {

        document.getElementById("productafter").value = (Number(document.getElementById("productbefore").value) + Number(document.getElementById("productquantity").value)).toFixed(3);
    }

}



function addproductvalue()
{

    document.getElementById("productafter").value = Number(document.getElementById("productbefore").value) + Number(document.getElementById("productquantity").value);
}


function discountproductvalue()
{
    var productbefore = Number(document.getElementById("productbefore").value);
    var productquantity = Number(document.getElementById("productquantity").value);

    if (productquantity > productbefore)
    {
        document.getElementById("productquantity").value = productbefore;
    }

    document.getElementById("productafter").value = Number(document.getElementById("productbefore").value) - Number(document.getElementById("productquantity").value);
}


$('#saveSettBtn').live('click', function (e) {
    var storeid = $('#storeid').val();
    var productid = $('#productid').val();
    var productquantity = $('#productquantity').val();
    //  var productbefore = $('#productbefore').val();

    if (storeid == '-1') {
        $('#storeError').show();
        $('#storeError').html("<p style='color: #CC3333;border: 1px solid #CC3333;width: 69px;'>*اختر مخزن</p>");
    } else if (productid == '') {
        $('#storeError').hide();
        $('#productError').show();
        $('#productError').html("<p style='color: #CC3333;border: 1px solid #CC3333;width: 98px;'>*   اختر منتج </p>");
    } else if (productquantity == '') {
        $('#productError').hide();
        $('#quantityError').show();
        $('#quantityError').html("<p style='color: #CC3333;border: 1px solid #CC3333;width: 124px;'>* ادخل  الكمية المتغيرة</p>");
    } else {
        $('#quantityError').hide();
        $('#settForm').submit();
        $('#saveSettBtn').attr("disabled", true);
    }
});

