<?php

/**
 * Class that operate on table 'returnbuybilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ReturnbuybilldetailMySqlExtDAO extends ReturnbuybilldetailMySqlDAO {

    public function queryQuantityWithProduct($productId) {
        $sql = 'SELECT SUM(returnbuybilldetail.returnbuybilldetailquantity) as sumQuantity
		 FROM returnbuybilldetail JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.conditions = 0
		 and returnbuybilldetail.returnbuybilldetailproductid = ' . $productId . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryQuantityWithProductAndDate($productId, $startDate, $endDate) {
        $sql = 'SELECT SUM(returnbuybilldetail.returnbuybilldetailquantity) as sumQuantity
		 FROM returnbuybilldetail JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.conditions = 0
		 and returnbuybilldetail.returnbuybilldetailproductid = ' . $productId . '
		 and returnbuybill.returnbuybilldate >= "' . $startDate . '" and returnbuybill.returnbuybilldate <= "' . $endDate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryQuantityWithProductAndDate2($productId, $startDate, $endDate, $queryString = '') {
//        $sql = 'SELECT sum( returnbuybilldetail.returnbuybilldetailquantity ) as returnbuybilldetailquantity ,
//                        returnbuybilldetail.productunitid as productunitid
//		 FROM returnbuybilldetail
//                 JOIN returnbuybill ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
//		 where returnbuybill.conditions = 0
//		 and returnbuybilldetail.returnbuybilldetailcatid = ' . $productId . '
//		 and returnbuybill.returnbuybilldate >= "' . $startDate . '" and returnbuybill.returnbuybilldate <= "' . $endDate . '"';

        $sql = 'SELECT
                returnbuybilldetail.returnbuybilldetailproductid as returnbuybilldetailproductid ,
                sum( returnbuybilldetail.returnbuybilldetailquantity )as returnbuybilldetailquantity  ,
                returnbuybilldetail.productunitid as productunitid
                FROM returnbuybilldetail
                JOIN returnbuybill ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid

                where  returnbuybilldetail.returnbuybilldetailproductid   = ' . $productId . ' and returnbuybill.returnbuybilldate >= "' . $startDate . '" and returnbuybill.returnbuybilldate <= "' . $endDate . '"
                    ' . $queryString . '
                group by ( returnbuybilldetail.returnbuybilldetailproductid ) ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryByBuyReturnbuybillIdExt($value) {
        $sql = 'SELECT returnbuybilldetail.*, product.productName, unit.unitName , productcat.productCatName
                ,size.name as sizeName,color.name as colorName
		 FROM returnbuybilldetail JOIN product
		 ON returnbuybilldetail.returnbuybilldetailproductid = product.productId
		 left JOIN productunit
		 ON returnbuybilldetail.productunitid = productunit.productunitid
		 left JOIN unit
		 ON unit.unitId = productunit.unitid
		 JOIN productcat
		 ON productcat.productCatId = product.productCatId

                left join sizecolor as size on size.id = returnbuybilldetail.sizeid
                left join sizecolor as color on color.id = returnbuybilldetail.colorid

		   WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);

        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditions($startDate, $endDate) {
        $sql = 'SELECT returnbuybilldetail.*
		 FROM returnbuybilldetail JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.conditions = 0
		 and returnbuybill.returnbuybilldate >= "' . $startDate . '" and returnbuybill.returnbuybilldate <= "' . $endDate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductId($startDate, $endDate, $ProductId) {
        $sql = 'SELECT returnbuybilldetail.*
		 FROM returnbuybilldetail JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.conditions = 0
		 and returnbuybill.returnbuybilldate
		 >= "' . $startDate . '" and returnbuybill.returnbuybilldate <= "' . $endDate . '"
		 and returnbuybilldetailproductid =' . $ProductId . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductIdandstore($startDate, $endDate, $ProductId, $storid) {
        $sql = 'SELECT returnbuybilldetail.*
		 FROM returnbuybilldetail JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.conditions = 0
		 and returnbuybill.returnbuybilldate
		 >= "' . $startDate . '" and returnbuybill.returnbuybilldate <= "' . $endDate . '"
		 and returnbuybill.returnbuybillstoreid=' . $storid . '
		 and returnbuybilldetailproductid =' . $ProductId . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndConditionsAndProductIdandstoreNew($queryString) {
        $sql = 'SELECT returnbuybilldetail.*
		 FROM returnbuybilldetail JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.conditions = 0
		 ' . $queryString . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function countProductInBuyBill($returnbuybillid) {
        $sql = 'SELECT  SUM(returnbuybilldetail.returnbuybilldetailquantity) as totalQty
		 FROM returnbuybilldetail
		 JOIN returnbuybill
		 ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
		 where returnbuybill.returnbuybillid =' . $returnbuybillid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryAllnothaveuintid() {
        $sql = 'SELECT * FROM returnbuybilldetail where returnbuybilldetail.productunitid not in(

		SELECT productunitid FROM `productunit`  )';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateproductunit($returnbuybilldetail) {
        $sql = 'UPDATE returnbuybilldetail SET  productunitid = ? WHERE returnbuybilldetailid = ?';


        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->setNumber($returnbuybilldetail->productunitid);

        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailid);

        //print_r($sqlQuery);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuybillidExt($value) {
        $sql = 'SELECT returnbuybilldetail.*, product.productName, unit.unitName ,unit.unitid ,productunit.productnumber ,productcat.productCatName
		 FROM returnbuybilldetail JOIN product
		 ON returnbuybilldetail.returnbuybilldetailproductid = product.productId left JOIN productunit
		 ON returnbuybilldetail.productunitid = productunit.productunitid
		 left JOIN unit
		 ON unit.unitId = productunit.unitid
		 JOIN productcat
		 ON productcat.productCatId = product.productCatId
		   WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function getsumdiscount($returnbuybillid) {
        $sql = 'SELECT sum(discountvalue) FROM returnbuybilldetail where returnbuybillid=' . $returnbuybillid . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function queryBillNoOfPecies($billid) {
        $sql = 'SELECT sum(returnbuybilldetail.returnbuybilldetailquantity) as note
        FROM returnbuybilldetail WHERE returnbuybillid = ' . $billid;
        $sqlQuery = new SqlQuery($sql);
        //echo $sql . "<br/>";
        return $this->getRow($sqlQuery);
    }

    public function queryAllGeneral($queryString) {
        $sql = 'SELECT returnbuybilldetail.*,product.productName as productName,unit.unitId as unitid,unit.unitName as unitName,productcat.productCatName,product.productCatId,product.logo,returnbuybill.returnbuybilltotalbill as Parcode,returnbuybill.returnbuybillaftertotalbill as note,returnbuybill.userid
                FROM returnbuybilldetail
                join productunit on productunit.productunitid = returnbuybilldetail.productunitid
                join unit on unit.unitId = productunit.unitid
                JOIN returnbuybill ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
                join product on product.productId = returnbuybilldetail.returnbuybilldetailproductid
                join productcat on productcat.productCatId = product.productCatId
                ' . $queryString . '
                AND returnbuybill.conditions = 0 order by returnbuybilldetail.returnbuybilldetailproductid';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllGeneralSimple($queryString) {
        $sql = 'SELECT returnbuybilldetail.returnbuybilldetailquantity,returnbuybilldetail.productunitid,returnbuybill.returnbuybillid,returnbuybill.returnbuybilldate,suppliername as discountvalue,storeName as note
		 FROM returnbuybilldetail
                 JOIN returnbuybill ON returnbuybilldetail.returnbuybillid = returnbuybill.returnbuybillid
                 join supplier on returnbuybill.returnbuybillsupplierid = supplier.supplierid
                 join store on returnbuybill.returnbuybillstoreid = store.storeId
		 ' . $queryString . ' AND returnbuybill.conditions = 0
                 AND (returnbuybill.deletedbuyid=0 || returnbuybill.deletedbuyid is null) order by returnbuybilldetail.returnbuybilldetailproductid';
        //echo $sql . "<br/>";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function getAutoIncrementValue($DBName) {
        $sql = 'SELECT `AUTO_INCREMENT`
                FROM  INFORMATION_SCHEMA.TABLES
                WHERE TABLE_SCHEMA = "' . $DBName . '"
                AND   TABLE_NAME   = "returnbuybill" ';

        $sqlQuery = new SqlQuery($sql); //
        return $this->querySingleResult($sqlQuery);
    }

    public function getproductpricebuy($productId, $storereportmodelid) {
        $sql = 'SELECT returnbuybilldetail.*
        FROM returnbuybilldetail
        WHERE returnbuybilldetailproductid = ' . $productId . ' and returnbuybillid=' . $storereportmodelid;
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

}

?>