<?php

/**
 * Class that operate on table 'restaurantplaystation'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-04-05 21:26
 */
class RestaurantplaystationMySqlExtDAO extends RestaurantplaystationMySqlDAO {

    public function loadEX($id) {
        $sql = 'SELECT restaurantplaystation.* ,restauranttable.hallid
                        FROM restaurantplaystation
                        left join restauranttable on restauranttable.id = restaurantplaystation.tableId
                        WHERE restaurantplaystation.id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    public function queryAllRestaurantPlaystationWithPlayData() {
        $sql = 'SELECT restaurantplaystation.*,startsysDate,reservationType,reservationEndDateTime,priceIs
                        FROM restaurantplaystation
                        left join restaurantplaystationplay on (restaurantplaystationplay.playstationid = restaurantplaystation.id and restaurantplaystationplay.finished = 0)
                        WHERE restaurantplaystation.del = 0
                        order by restaurantplaystation.id asc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithQueryString($queryString = '') {
        $sql = 'SELECT *
                        FROM restaurantplaystation
                        WHERE 1 ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>