<?php

/**
 * Class that operate on table 'withdrawals'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class WithdrawalsMySqlDAO implements WithdrawalsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return WithdrawalsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM withdrawals WHERE withdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM withdrawals';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM withdrawals ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param withdrawal primary key
     */
    public function delete($withdrawalid) {
        $sql = 'DELETE FROM withdrawals WHERE withdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($withdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param WithdrawalsMySql withdrawal
     */
    public function insert($withdrawal) {
        $sql = 'INSERT INTO withdrawals (withdrawalvalue, withdrawalcomment, currentdate, tempdelete) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($withdrawal->withdrawalvalue);
        $sqlQuery->set($withdrawal->withdrawalcomment);
        $sqlQuery->set($withdrawal->currentdate);
        $sqlQuery->setNumber($withdrawal->tempdelete);

        $id = $this->executeInsert($sqlQuery);
        $withdrawal->withdrawalid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param WithdrawalsMySql withdrawal
     */
    public function update($withdrawal) {
        $sql = 'UPDATE withdrawals SET withdrawalvalue = ?, withdrawalcomment = ?, currentdate = ?, tempdelete = ? WHERE withdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($withdrawal->withdrawalvalue);
        $sqlQuery->set($withdrawal->withdrawalcomment);
        $sqlQuery->set($withdrawal->currentdate);
        $sqlQuery->setNumber($withdrawal->tempdelete);

        $sqlQuery->setNumber($withdrawal->withdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM withdrawals';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByWithdrawalvalue($value) {
        $sql = 'SELECT * FROM withdrawals WHERE withdrawalvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWithdrawalcomment($value) {
        $sql = 'SELECT * FROM withdrawals WHERE withdrawalcomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM withdrawals WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM withdrawals WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByWithdrawalvalue($value) {
        $sql = 'DELETE FROM withdrawals WHERE withdrawalvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWithdrawalcomment($value) {
        $sql = 'DELETE FROM withdrawals WHERE withdrawalcomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM withdrawals WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM withdrawals WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return WithdrawalsMySql
     */
    protected function readRow($row) {
        $withdrawal = new Withdrawal();

        $withdrawal->withdrawalid = isset($row['withdrawalid']) ? $row['withdrawalid'] : '';
        $withdrawal->withdrawalvalue = isset($row['withdrawalvalue']) ? $row['withdrawalvalue'] : '';
        $withdrawal->withdrawalcomment = isset($row['withdrawalcomment']) ? $row['withdrawalcomment'] : '';
        $withdrawal->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';
        $withdrawal->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';

        return $withdrawal;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return WithdrawalsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>