<?php
/**
 * Class that operate on table 'typesupplier'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 22:19
 */
class TypesupplierMySqlDAO implements TypesupplierDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TypesupplierMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM typesupplier WHERE typeId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM typesupplier';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM typesupplier ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param typesupplier primary key
 	 */
	public function delete($typeId){
		$sql = 'DELETE FROM typesupplier WHERE typeId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($typeId);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TypesupplierMySql typesupplier
 	 */
	public function insert($typesupplier){
		$sql = 'INSERT INTO typesupplier (typeName, conditions, comments, typeDate, category_id) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($typesupplier->typeName);
		$sqlQuery->setNumber($typesupplier->conditions);
		$sqlQuery->setString2($typesupplier->comments);
		$sqlQuery->set($typesupplier->typeDate);
		$sqlQuery->set($typesupplier->category_id);

		$id = $this->executeInsert($sqlQuery);
		$typesupplier->typeId = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TypesupplierMySql typesupplier
 	 */
	public function update($typesupplier){
		$sql = 'UPDATE typesupplier SET typeName = ?, conditions = ?, comments = ?, typeDate = ? ,category_id = ? WHERE typeId = ? ';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($typesupplier->typeName);
		$sqlQuery->setNumber($typesupplier->conditions);
		$sqlQuery->setString2($typesupplier->comments);
		$sqlQuery->set($typesupplier->typeDate);
        $sqlQuery->set($typesupplier->category_id);

        $sqlQuery->setNumber($typesupplier->typeId);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM typesupplier';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTypeName($value){
		$sql = 'SELECT * FROM typesupplier WHERE typeName = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM typesupplier WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComments($value){
		$sql = 'SELECT * FROM typesupplier WHERE comments = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTypeDate($value){
		$sql = 'SELECT * FROM typesupplier WHERE typeDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTypeName($value){
		$sql = 'DELETE FROM typesupplier WHERE typeName = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM typesupplier WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComments($value){
		$sql = 'DELETE FROM typesupplier WHERE comments = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTypeDate($value){
		$sql = 'DELETE FROM typesupplier WHERE typeDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TypesupplierMySql 
	 */
	protected function readRow($row){
		$typesupplier = new Typesupplier();
		
		$typesupplier->typeId = $row['typeId'];
		$typesupplier->typeName = $row['typeName'];
		$typesupplier->conditions = $row['conditions'];
		$typesupplier->comments = $row['comments'];
		$typesupplier->typeDate = $row['typeDate'];
		$typesupplier->category_id = $row['category_id'];

		return $typesupplier;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TypesupplierMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>