<?php

/**
 * Class that operate on table 'tamweenda3mstatus'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-12-14 16:00
 */
class Tamweenda3mstatusMySqlDAO implements Tamweenda3mstatusDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return Tamweenda3mstatusMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM tamweenda3mstatus';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM tamweenda3mstatus ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param tamweenda3mstatu primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param Tamweenda3mstatusMySql tamweenda3mstatu
     */
    public function insert($tamweenda3mstatu) {
        $sql = 'INSERT INTO tamweenda3mstatus (clientid, month, tamweenStatus, da3mStatus, userid, sysdate, del,useridTamween,sysdateTamween) VALUES (?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($tamweenda3mstatu->clientid);
        $sqlQuery->set($tamweenda3mstatu->month);
        $sqlQuery->setNumber($tamweenda3mstatu->tamweenStatus);
        $sqlQuery->setNumber($tamweenda3mstatu->da3mStatus);
        $sqlQuery->setNumber($tamweenda3mstatu->userid);
        $sqlQuery->set($tamweenda3mstatu->sysdate);
        $sqlQuery->setNumber($tamweenda3mstatu->del);
        $sqlQuery->setNumber($tamweenda3mstatu->useridTamween);
        $sqlQuery->set($tamweenda3mstatu->sysdateTamween);

        $id = $this->executeInsert($sqlQuery);
        $tamweenda3mstatu->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param Tamweenda3mstatusMySql tamweenda3mstatu
     */
    public function update($tamweenda3mstatu) {
        $sql = 'UPDATE tamweenda3mstatus SET clientid = ?, month = ?, tamweenStatus = ?, da3mStatus = ?, userid = ?, sysdate = ?, del = ?,useridTamween = ?,sysdateTamween = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($tamweenda3mstatu->clientid);
        $sqlQuery->set($tamweenda3mstatu->month);
        $sqlQuery->setNumber($tamweenda3mstatu->tamweenStatus);
        $sqlQuery->setNumber($tamweenda3mstatu->da3mStatus);
        $sqlQuery->setNumber($tamweenda3mstatu->userid);
        $sqlQuery->set($tamweenda3mstatu->sysdate);
        $sqlQuery->setNumber($tamweenda3mstatu->del);
        $sqlQuery->setNumber($tamweenda3mstatu->useridTamween);
        $sqlQuery->set($tamweenda3mstatu->sysdateTamween);

        $sqlQuery->setNumber($tamweenda3mstatu->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM tamweenda3mstatus';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMonth($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE month = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTamweenStatus($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE tamweenStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDa3mStatus($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE da3mStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM tamweenda3mstatus WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMonth($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE month = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTamweenStatus($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE tamweenStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDa3mStatus($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE da3mStatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM tamweenda3mstatus WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return Tamweenda3mstatusMySql
     */
    protected function readRow($row) {
        $tamweenda3mstatu = new Tamweenda3mstatu();

        $tamweenda3mstatu->id = $row['id'];
        $tamweenda3mstatu->clientid = $row['clientid'];
        $tamweenda3mstatu->month = $row['month'];
        $tamweenda3mstatu->tamweenStatus = $row['tamweenStatus'];
        $tamweenda3mstatu->da3mStatus = $row['da3mStatus'];
        $tamweenda3mstatu->userid = $row['userid'];
        $tamweenda3mstatu->sysdate = $row['sysdate'];
        $tamweenda3mstatu->del = $row['del'];
        $tamweenda3mstatu->useridTamween = $row['useridTamween'];
        $tamweenda3mstatu->sysdateTamween = $row['sysdateTamween'];
        //
        $tamweenda3mstatu->clientname = $row['clientname'];
        $tamweenda3mstatu->employeename = $row['employeename'];

        return $tamweenda3mstatu;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return Tamweenda3mstatusMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>