<?php

/**
 * Class that operate on table 'tamweenbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-12-14 16:00
 */
class TamweenbillMySqlDAO implements TamweenbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TamweenbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM tamweenbill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM tamweenbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM tamweenbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param tamweenbill primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM tamweenbill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TamweenbillMySql tamweenbill
     */
    public function insert($tamweenbill) {
        $sql = 'INSERT INTO tamweenbill (clientid, quantity, billdate, billMonthDays, comment, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($tamweenbill->clientid);
        $sqlQuery->setNumber($tamweenbill->quantity);
        $sqlQuery->set($tamweenbill->billdate);
        $sqlQuery->setNumber($tamweenbill->billMonthDays);
        $sqlQuery->setString2($tamweenbill->comment);
        $sqlQuery->setNumber($tamweenbill->userid);
        $sqlQuery->set($tamweenbill->sysdate);
        $sqlQuery->setNumber($tamweenbill->del);

        $id = $this->executeInsert($sqlQuery);
        $tamweenbill->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TamweenbillMySql tamweenbill
     */
    public function update($tamweenbill) {
        $sql = 'UPDATE tamweenbill SET clientid = ?, quantity = ?, billdate = ?, billMonthDays = ?, comment = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($tamweenbill->clientid);
        $sqlQuery->setNumber($tamweenbill->quantity);
        $sqlQuery->set($tamweenbill->billdate);
        $sqlQuery->setNumber($tamweenbill->billMonthDays);
        $sqlQuery->setString2($tamweenbill->comment);
        $sqlQuery->setNumber($tamweenbill->userid);
        $sqlQuery->set($tamweenbill->sysdate);
        $sqlQuery->setNumber($tamweenbill->del);

        $sqlQuery->setNumber($tamweenbill->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM tamweenbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBilldate($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE billdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillMonthDays($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE billMonthDays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM tamweenbill WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM tamweenbill WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM tamweenbill WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBilldate($value) {
        $sql = 'DELETE FROM tamweenbill WHERE billdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillMonthDays($value) {
        $sql = 'DELETE FROM tamweenbill WHERE billMonthDays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM tamweenbill WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM tamweenbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM tamweenbill WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM tamweenbill WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TamweenbillMySql
     */
    protected function readRow($row) {
        $tamweenbill = new Tamweenbill();

        $tamweenbill->id = $row['id'];
        $tamweenbill->clientid = $row['clientid'];
        $tamweenbill->quantity = $row['quantity'];
        $tamweenbill->billdate = $row['billdate'];
        $tamweenbill->billMonthDays = $row['billMonthDays'];
        $tamweenbill->comment = $row['comment'];
        $tamweenbill->userid = $row['userid'];
        $tamweenbill->sysdate = $row['sysdate'];
        $tamweenbill->del = $row['del'];
        //
        $tamweenbill->clientname = $row['clientname'];
        $tamweenbill->clientcode = $row['clientcode'];
        $tamweenbill->noOfPersonsDa3m = $row['noOfPersonsDa3m'];
        $tamweenbill->tamweenremainstatusid = $row['tamweenremainstatusid'];
        $tamweenbill->remainstatus = $row['remainstatus'];
        $tamweenbill->employeename = $row['employeename'];
        $tamweenbill->cardNum = $row['cardNum'];
        $tamweenbill->takenInAMonthQuantity = $row['takenInAMonthQuantity'];
        $tamweenbill->addDate = $row['addDate'];

        return $tamweenbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TamweenbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>