<?php

/**
 * Class that operate on table 'supply'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class SupplyMySqlDAO implements SupplyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SupplyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM supply WHERE supplyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM supply';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM supply ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param supply primary key
     */
    public function delete($supplyid) {
        $sql = 'DELETE FROM supply WHERE supplyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($supplyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SupplyMySql supply
     */
    public function insert($supply) {
        $sql = 'INSERT INTO supply (supplyvalue, supplycomment, currentdate, tempdelete) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($supply->supplyvalue);
        $sqlQuery->set($supply->supplycomment);
        $sqlQuery->set($supply->currentdate);
        $sqlQuery->setNumber($supply->tempdelete);

        $id = $this->executeInsert($sqlQuery);
        $supply->supplyid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SupplyMySql supply
     */
    public function update($supply) {
        $sql = 'UPDATE supply SET supplyvalue = ?, supplycomment = ?, currentdate = ?, tempdelete = ? WHERE supplyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($supply->supplyvalue);
        $sqlQuery->set($supply->supplycomment);
        $sqlQuery->set($supply->currentdate);
        $sqlQuery->setNumber($supply->tempdelete);

        $sqlQuery->setNumber($supply->supplyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM supply';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySupplyvalue($value) {
        $sql = 'SELECT * FROM supply WHERE supplyvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplycomment($value) {
        $sql = 'SELECT * FROM supply WHERE supplycomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentdate($value) {
        $sql = 'SELECT * FROM supply WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM supply WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySupplyvalue($value) {
        $sql = 'DELETE FROM supply WHERE supplyvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplycomment($value) {
        $sql = 'DELETE FROM supply WHERE supplycomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentdate($value) {
        $sql = 'DELETE FROM supply WHERE currentdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM supply WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SupplyMySql
     */
    protected function readRow($row) {
        $supply = new Supply();

        $supply->supplyid = isset($row['supplyid']) ? $row['supplyid'] : '';
        $supply->supplyvalue = isset($row['supplyvalue']) ? $row['supplyvalue'] : '';
        $supply->supplycomment = isset($row['supplycomment']) ? $row['supplycomment'] : '';
        $supply->currentdate = isset($row['currentdate']) ? $row['currentdate'] : '';
        $supply->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';

        return $supply;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SupplyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>