<?php
/**
 * Class that operate on table 'sellbillandreturnreview'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-05-05 18:38
 */
class SellbillandreturnreviewMySqlDAO implements SellbillandreturnreviewDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return SellbillandreturnreviewMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM sellbillandreturnreview WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM sellbillandreturnreview';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM sellbillandreturnreview ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param sellbillandreturnreview primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM sellbillandreturnreview WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param SellbillandreturnreviewMySql sellbillandreturnreview
 	 */
	public function insert($sellbillandreturnreview){
		$sql = 'INSERT INTO sellbillandreturnreview (billid, reviewType, reviewuserid, sysdate, del) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sellbillandreturnreview->billid);
		$sqlQuery->setNumber($sellbillandreturnreview->reviewType);
		$sqlQuery->setNumber($sellbillandreturnreview->reviewuserid);
		$sqlQuery->set($sellbillandreturnreview->sysdate);
		$sqlQuery->setNumber($sellbillandreturnreview->del);

		$id = $this->executeInsert($sqlQuery);	
		$sellbillandreturnreview->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param SellbillandreturnreviewMySql sellbillandreturnreview
 	 */
	public function update($sellbillandreturnreview){
		$sql = 'UPDATE sellbillandreturnreview SET billid = ?, reviewType = ?, reviewuserid = ?, sysdate = ?, del = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sellbillandreturnreview->billid);
		$sqlQuery->setNumber($sellbillandreturnreview->reviewType);
		$sqlQuery->setNumber($sellbillandreturnreview->reviewuserid);
		$sqlQuery->set($sellbillandreturnreview->sysdate);
		$sqlQuery->setNumber($sellbillandreturnreview->del);

		$sqlQuery->setNumber($sellbillandreturnreview->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM sellbillandreturnreview';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByBillid($value){
		$sql = 'SELECT * FROM sellbillandreturnreview WHERE billid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReviewType($value){
		$sql = 'SELECT * FROM sellbillandreturnreview WHERE reviewType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReviewuserid($value){
		$sql = 'SELECT * FROM sellbillandreturnreview WHERE reviewuserid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM sellbillandreturnreview WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM sellbillandreturnreview WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByBillid($value){
		$sql = 'DELETE FROM sellbillandreturnreview WHERE billid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReviewType($value){
		$sql = 'DELETE FROM sellbillandreturnreview WHERE reviewType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReviewuserid($value){
		$sql = 'DELETE FROM sellbillandreturnreview WHERE reviewuserid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM sellbillandreturnreview WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM sellbillandreturnreview WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return SellbillandreturnreviewMySql 
	 */
	protected function readRow($row){
		$sellbillandreturnreview = new Sellbillandreturnreview();
		
		$sellbillandreturnreview->id = $row['id'];
		$sellbillandreturnreview->billid = $row['billid'];
		$sellbillandreturnreview->reviewType = $row['reviewType'];
		$sellbillandreturnreview->reviewuserid = $row['reviewuserid'];
		$sellbillandreturnreview->sysdate = $row['sysdate'];
		$sellbillandreturnreview->del = $row['del'];

		return $sellbillandreturnreview;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return SellbillandreturnreviewMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>