<?php

/**
 * Class that operate on table 'projectexchmaterialdetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-28 14:17
 */
class ProjectexchmaterialdetailMySqlDAO implements ProjectexchmaterialdetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProjectexchmaterialdetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM projectexchmaterialdetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM projectexchmaterialdetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM projectexchmaterialdetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param projectexchmaterialdetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM projectexchmaterialdetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProjectexchmaterialdetailMySql projectexchmaterialdetail
     */
    public function insert($projectexchmaterialdetail) {
        $sql = 'INSERT INTO projectexchmaterialdetail (projectexchid, productid, pronumber, probuyprice, expensestypeid) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($projectexchmaterialdetail->projectexchid);
        $sqlQuery->setNumber($projectexchmaterialdetail->productid);
        $sqlQuery->setNumber($projectexchmaterialdetail->pronumber);
        $sqlQuery->setNumber($projectexchmaterialdetail->probuyprice);
        $sqlQuery->setNumber($projectexchmaterialdetail->expensestypeid);

        $id = $this->executeInsert($sqlQuery);
        $projectexchmaterialdetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProjectexchmaterialdetailMySql projectexchmaterialdetail
     */
    public function update($projectexchmaterialdetail) {
        $sql = 'UPDATE projectexchmaterialdetail SET projectexchid = ?, productid = ?, pronumber = ? , probuyprice = ? , expensestypeid = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($projectexchmaterialdetail->projectexchid);
        $sqlQuery->setNumber($projectexchmaterialdetail->productid);
        $sqlQuery->setNumber($projectexchmaterialdetail->pronumber);
        $sqlQuery->setNumber($projectexchmaterialdetail->probuyprice);
        $sqlQuery->setNumber($projectexchmaterialdetail->expensestypeid);

        $sqlQuery->setNumber($projectexchmaterialdetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM projectexchmaterialdetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProjectexchid($value) {
        $sql = 'SELECT * FROM projectexchmaterialdetail WHERE projectexchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM projectexchmaterialdetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPronumber($value) {
        $sql = 'SELECT * FROM projectexchmaterialdetail WHERE pronumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProjectexchid($value) {
        $sql = 'DELETE FROM projectexchmaterialdetail WHERE projectexchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM projectexchmaterialdetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPronumber($value) {
        $sql = 'DELETE FROM projectexchmaterialdetail WHERE pronumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProjectexchmaterialdetailMySql
     */
    protected function readRow($row) {
        $projectexchmaterialdetail = new Projectexchmaterialdetail();

        $projectexchmaterialdetail->id = isset($row['id']) ? $row['id'] : '';
        $projectexchmaterialdetail->projectexchid = isset($row['projectexchid']) ? $row['projectexchid'] : '';
        $projectexchmaterialdetail->productid = isset($row['productid']) ? $row['productid'] : '';
        $projectexchmaterialdetail->pronumber = isset($row['pronumber']) ? $row['pronumber'] : '';
        $projectexchmaterialdetail->probuyprice = isset($row['probuyprice']) ? $row['probuyprice'] : '';
        $projectexchmaterialdetail->expensestypeid = isset($row['expensestypeid']) ? $row['expensestypeid'] : '';

        return $projectexchmaterialdetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProjectexchmaterialdetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>