<?php

/**
 * Class that operate on table 'manufacuresetting'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-15 14:14
 */
class ManufacuresettingMySqlDAO implements ManufacuresettingDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ManufacuresettingMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM manufacuresetting WHERE manufacuresettingid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM manufacuresetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM manufacuresetting ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param manufacuresetting primary key
     */
    public function delete($manufacuresettingid) {
        $sql = 'DELETE FROM manufacuresetting WHERE manufacuresettingid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($manufacuresettingid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ManufacuresettingMySql manufacuresetting
     */
    public function insert($manufacuresetting) {
        $sql = 'INSERT INTO manufacuresetting (ordername, excahangeorder) VALUES (?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($manufacuresetting->ordername);
        $sqlQuery->setNumber($manufacuresetting->excahangeorder);

        $id = $this->executeInsert($sqlQuery);
        $manufacuresetting->manufacuresettingid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ManufacuresettingMySql manufacuresetting
     */
    public function update($manufacuresetting) {
        $sql = 'UPDATE manufacuresetting SET ordername = ?, excahangeorder = ? WHERE manufacuresettingid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($manufacuresetting->ordername);
        $sqlQuery->setNumber($manufacuresetting->excahangeorder);

        $sqlQuery->setNumber($manufacuresetting->manufacuresettingid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM manufacuresetting';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOrdername($value) {
        $sql = 'SELECT * FROM manufacuresetting WHERE ordername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExcahangeorder($value) {
        $sql = 'SELECT * FROM manufacuresetting WHERE excahangeorder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOrdername($value) {
        $sql = 'DELETE FROM manufacuresetting WHERE ordername = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExcahangeorder($value) {
        $sql = 'DELETE FROM manufacuresetting WHERE excahangeorder = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ManufacuresettingMySql
     */
    protected function readRow($row) {
        $manufacuresetting = new Manufacuresetting();

        $manufacuresetting->manufacuresettingid = isset($row['manufacuresettingid']) ? $row['manufacuresettingid'] : '';
        $manufacuresetting->ordername = isset($row['ordername']) ? $row['ordername'] : '';
        $manufacuresetting->excahangeorder = isset($row['excahangeorder']) ? $row['excahangeorder'] : '';

        return $manufacuresetting;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ManufacuresettingMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>