<?php
/**
 * Class that operate on table 'maccontrol'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-02-17 01:27
 */
class MaccontrolMySqlDAO implements MaccontrolDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return MaccontrolMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM maccontrol WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM maccontrol';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM maccontrol ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param maccontrol primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM maccontrol WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MaccontrolMySql maccontrol
 	 */
	public function insert($maccontrol){
		$sql = 'INSERT INTO maccontrol (mac, deviceType, allowRemoteAccess, userid, del, sysdate) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($maccontrol->mac);
		$sqlQuery->set($maccontrol->deviceType);
		$sqlQuery->setNumber($maccontrol->allowRemoteAccess);
		$sqlQuery->setNumber($maccontrol->userid);
		$sqlQuery->setNumber($maccontrol->del);
		$sqlQuery->set($maccontrol->sysdate);

		$id = $this->executeInsert($sqlQuery);	
		$maccontrol->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param MaccontrolMySql maccontrol
 	 */
	public function update($maccontrol){
		$sql = 'UPDATE maccontrol SET mac = ?, deviceType = ?, allowRemoteAccess = ?, userid = ?, del = ?, sysdate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($maccontrol->mac);
		$sqlQuery->set($maccontrol->deviceType);
		$sqlQuery->setNumber($maccontrol->allowRemoteAccess);
		$sqlQuery->setNumber($maccontrol->userid);
		$sqlQuery->setNumber($maccontrol->del);
		$sqlQuery->set($maccontrol->sysdate);

		$sqlQuery->setNumber($maccontrol->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM maccontrol';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByMac($value){
		$sql = 'SELECT * FROM maccontrol WHERE mac = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDeviceType($value){
		$sql = 'SELECT * FROM maccontrol WHERE deviceType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByAllowRemoteAccess($value){
		$sql = 'SELECT * FROM maccontrol WHERE allowRemoteAccess = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM maccontrol WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM maccontrol WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM maccontrol WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function deleteByMac($value){
		$sql = 'DELETE FROM maccontrol WHERE mac = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDeviceType($value){
		$sql = 'DELETE FROM maccontrol WHERE deviceType = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByAllowRemoteAccess($value){
		$sql = 'DELETE FROM maccontrol WHERE allowRemoteAccess = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM maccontrol WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM maccontrol WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM maccontrol WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	
        
        
	/**
	 * Read row
	 *
	 * @return MaccontrolMySql 
	 */
	protected function readRow($row){
		$maccontrol = new Maccontrol();
		
		$maccontrol->id = $row['id'];
		$maccontrol->mac = $row['mac'];
		$maccontrol->deviceType = $row['deviceType'];
		$maccontrol->allowRemoteAccess = $row['allowRemoteAccess'];
		$maccontrol->userid = $row['userid'];
		$maccontrol->del = $row['del'];
		$maccontrol->sysdate = $row['sysdate'];

		return $maccontrol;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return MaccontrolMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>