<?php

/**
 * Class that operate on table 'm_producthistory'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MProducthistoryMySqlDAO implements MProducthistoryDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MProducthistoryMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_producthistory WHERE productHistoryId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_producthistory';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_producthistory ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mProducthistory primary key
     */
    public function delete($productHistoryId) {
        $sql = 'DELETE FROM m_producthistory WHERE productHistoryId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productHistoryId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MProducthistoryMySql mProducthistory
     */
    public function insert($mProducthistory) {
        $sql = 'INSERT INTO m_producthistory (ourSerial, stageFrom, stageTo, cost, comment, status, userId, productHistoryDate, branchId, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mProducthistory->ourSerial);
        $sqlQuery->setNumber($mProducthistory->stageFrom);
        $sqlQuery->setNumber($mProducthistory->stageTo);
        $sqlQuery->set($mProducthistory->cost);
        $sqlQuery->setString2($mProducthistory->comment);
        $sqlQuery->setNumber($mProducthistory->status);
        $sqlQuery->setNumber($mProducthistory->userId);
        $sqlQuery->set($mProducthistory->productHistoryDate);
        $sqlQuery->setNumber($mProducthistory->branchId);
        $sqlQuery->setNumber($mProducthistory->del);

        $id = $this->executeInsert($sqlQuery);
        $mProducthistory->productHistoryId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MProducthistoryMySql mProducthistory
     */
    public function update($mProducthistory) {
        $sql = 'UPDATE m_producthistory SET ourSerial = ?, stageFrom = ?, stageTo = ?, cost = ?, comment = ?, status = ?, userId = ?, productHistoryDate = ?, branchId = ?, del = ? WHERE productHistoryId = ?';


        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mProducthistory->ourSerial);
        $sqlQuery->setNumber($mProducthistory->stageFrom);
        $sqlQuery->setNumber($mProducthistory->stageTo);
        $sqlQuery->set($mProducthistory->cost);
        $sqlQuery->setString2($mProducthistory->comment);
        $sqlQuery->setNumber($mProducthistory->status);
        $sqlQuery->setNumber($mProducthistory->userId);
        $sqlQuery->set($mProducthistory->productHistoryDate);
        $sqlQuery->setNumber($mProducthistory->branchId);
        $sqlQuery->setNumber($mProducthistory->del);

        $sqlQuery->setNumber($mProducthistory->productHistoryId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_producthistory';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOurSerial($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageFrom($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE stageFrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageTo($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE stageTo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStatus($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductHistoryDate($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE productHistoryDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_producthistory WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOurSerial($value) {
        $sql = 'DELETE FROM m_producthistory WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageFrom($value) {
        $sql = 'DELETE FROM m_producthistory WHERE stageFrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageTo($value) {
        $sql = 'DELETE FROM m_producthistory WHERE stageTo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM m_producthistory WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStatus($value) {
        $sql = 'DELETE FROM m_producthistory WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_producthistory WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductHistoryDate($value) {
        $sql = 'DELETE FROM m_producthistory WHERE productHistoryDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_producthistory WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_producthistory WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MProducthistoryMySql
     */
    protected function readRow($row) {
        $mProducthistory = new MProducthistory();

        $mProducthistory->productHistoryId = isset($row['productHistoryId']) ? $row['productHistoryId'] : '';
        $mProducthistory->ourSerial = isset($row['ourSerial']) ? $row['ourSerial'] : '';
        $mProducthistory->stageFrom = isset($row['stageFrom']) ? $row['stageFrom'] : '';
        $mProducthistory->stageTo = isset($row['stageTo']) ? $row['stageTo'] : '';
        $mProducthistory->cost = isset($row['cost']) ? $row['cost'] : '';
        $mProducthistory->comment = isset($row['comment']) ? $row['comment'] : '';
        $mProducthistory->status = isset($row['status']) ? $row['status'] : '';
        $mProducthistory->userId = isset($row['userId']) ? $row['userId'] : '';
        $mProducthistory->productHistoryDate = isset($row['productHistoryDate']) ? $row['productHistoryDate'] : '';
        $mProducthistory->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mProducthistory->del = isset($row['del']) ? $row['del'] : '';
        //req
        $mProducthistory->stageTitle = isset($row['stageTitle']) ? $row['stageTitle'] : '';
        $mProducthistory->stageTitle2 = isset($row['stageTitle2']) ? $row['stageTitle2'] : '';

        $mProducthistory->productserial = isset($row['productserial']) ? $row['productserial'] : '';
        $mProducthistory->receiptserial = isset($row['receiptserial']) ? $row['receiptserial'] : '';
        $mProducthistory->productName = isset($row['productName']) ? $row['productName'] : '';
        $mProducthistory->granttype = isset($row['granttype']) ? $row['granttype'] : '';
        $mProducthistory->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $mProducthistory->title = isset($row['title']) ? $row['title'] : '';

        $mProducthistory->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';

        return $mProducthistory;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MProducthistoryMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>