<?php

/**
 * Class that operate on table 'insurancecompanies'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
class InsurancecompaniesMySqlDAO implements InsurancecompaniesDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return InsurancecompaniesMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM insurancecompanies WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM insurancecompanies';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM insurancecompanies ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param insurancecompanie primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM insurancecompanies WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param InsurancecompaniesMySql insurancecompanie
     */
    public function insert($insurancecompanie) {
        $sql = 'INSERT INTO insurancecompanies (name, discountpercent, contractstart, contractend, contractphoto, instruction, deleted, userid) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($insurancecompanie->name);
        $sqlQuery->set($insurancecompanie->discountpercent);
        $sqlQuery->set($insurancecompanie->contractstart);
        $sqlQuery->set($insurancecompanie->contractend);
        $sqlQuery->set($insurancecompanie->contractphoto);
        $sqlQuery->setString2($insurancecompanie->instruction);
        $sqlQuery->setNumber($insurancecompanie->deleted);
        $sqlQuery->setNumber($insurancecompanie->userid);

        $id = $this->executeInsert($sqlQuery);
        $insurancecompanie->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param InsurancecompaniesMySql insurancecompanie
     */
    public function update($insurancecompanie) {
        $sql = 'UPDATE insurancecompanies SET name = ?, discountpercent = ?, contractstart = ?, contractend = ?, contractphoto = ?, instruction = ?, deleted = ?, userid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($insurancecompanie->name);
        $sqlQuery->set($insurancecompanie->discountpercent);
        $sqlQuery->set($insurancecompanie->contractstart);
        $sqlQuery->set($insurancecompanie->contractend);
        $sqlQuery->set($insurancecompanie->contractphoto);
        $sqlQuery->setString2($insurancecompanie->instruction);
        $sqlQuery->setNumber($insurancecompanie->deleted);
        $sqlQuery->setNumber($insurancecompanie->userid);

        $sqlQuery->setNumber($insurancecompanie->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM insurancecompanies';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountpercent($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE discountpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContractstart($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE contractstart = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContractend($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE contractend = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContractphoto($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE contractphoto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInstruction($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE instruction = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM insurancecompanies WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountpercent($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE discountpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContractstart($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE contractstart = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContractend($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE contractend = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContractphoto($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE contractphoto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInstruction($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE instruction = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM insurancecompanies WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return InsurancecompaniesMySql
     */
    protected function readRow($row) {
        $insurancecompanie = new Insurancecompanie();

        $insurancecompanie->id = isset($row['id']) ? $row['id'] : '';
        $insurancecompanie->name = isset($row['name']) ? $row['name'] : '';
        $insurancecompanie->discountpercent = isset($row['discountpercent']) ? $row['discountpercent'] : '';
        $insurancecompanie->contractstart = isset($row['contractstart']) ? $row['contractstart'] : '';
        $insurancecompanie->contractend = isset($row['contractend']) ? $row['contractend'] : '';
        $insurancecompanie->contractphoto = isset($row['contractphoto']) ? $row['contractphoto'] : '';
        $insurancecompanie->instruction = isset($row['instruction']) ? $row['instruction'] : '';
        $insurancecompanie->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $insurancecompanie->userid = isset($row['userid']) ? $row['userid'] : '';

        return $insurancecompanie;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return InsurancecompaniesMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>