<?php

/**
 * Class that operate on table 'clinic'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
class ClinicMySqlDAO implements ClinicDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ClinicMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM clinic WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM clinic';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM clinic ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param clinic primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM clinic WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ClinicMySql clinic
     */
    public function insert($clinic) {
        $sql = 'INSERT INTO clinic (name, description, tempdel) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($clinic->name);
        $sqlQuery->setString2($clinic->description);
        $sqlQuery->setNumber($clinic->tempdel);

        $id = $this->executeInsert($sqlQuery);
        $clinic->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ClinicMySql clinic
     */
    public function update($clinic) {
        $sql = 'UPDATE clinic SET name = ?, description = ?, tempdel = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($clinic->name);
        $sqlQuery->setString2($clinic->description);
        $sqlQuery->setNumber($clinic->tempdel);

        $sqlQuery->setNumber($clinic->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM clinic';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM clinic WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescription($value) {
        $sql = 'SELECT * FROM clinic WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdel($value) {
        $sql = 'SELECT * FROM clinic WHERE tempdel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM clinic WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescription($value) {
        $sql = 'DELETE FROM clinic WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdel($value) {
        $sql = 'DELETE FROM clinic WHERE tempdel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ClinicMySql
     */
    protected function readRow($row) {
        $clinic = new Clinic();

        $clinic->id = isset($row['id']) ? $row['id'] : '';
        $clinic->name = isset($row['name']) ? $row['name'] : '';
        $clinic->description = isset($row['description']) ? $row['description'] : '';
        $clinic->tempdel = isset($row['tempdel']) ? $row['tempdel'] : '';

        return $clinic;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ClinicMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>