<?php

/**
 * Class that operate on table 'clientpaymentreceiptt'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-13 14:35
 */
class ClientpaymentreceipttMySqlDAO implements ClientpaymentreceipttDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ClientpaymentreceipttMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM clientpaymentreceiptt';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM clientpaymentreceiptt ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param clientpaymentreceiptt primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ClientpaymentreceipttMySql clientpaymentreceiptt
     */
    public function insert($clientpaymentreceiptt) {
        $sql = 'INSERT INTO clientpaymentreceiptt (clientid, billid, payedtype, paymethod, debtbefore, payed, debtafter,biltype,userid,sysdate,del,dailyentryid) VALUES (?,?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($clientpaymentreceiptt->clientid);
        $sqlQuery->setNumber($clientpaymentreceiptt->billid);
        $sqlQuery->setNumber($clientpaymentreceiptt->payedtype);
        $sqlQuery->setNumber($clientpaymentreceiptt->paymethod);
        $sqlQuery->set($clientpaymentreceiptt->debtbefore);
        $sqlQuery->set($clientpaymentreceiptt->payed);
        $sqlQuery->set($clientpaymentreceiptt->debtafter);
        $sqlQuery->set($clientpaymentreceiptt->biltype);
        $sqlQuery->setNumber($clientpaymentreceiptt->userid);
        $sqlQuery->set($clientpaymentreceiptt->sysdate);
        $sqlQuery->setNumber($clientpaymentreceiptt->del);
        $sqlQuery->setNumber($clientpaymentreceiptt->dailyentryid);

        $id = $this->executeInsert($sqlQuery);
        $clientpaymentreceiptt->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ClientpaymentreceipttMySql clientpaymentreceiptt
     */
    public function update($clientpaymentreceiptt) {
        $sql = 'UPDATE clientpaymentreceiptt SET clientid = ?, billid = ?, payedtype = ?, paymethod = ?, debtbefore = ?, payed = ?, debtafter = ?,biltype=?,userid = ?,sysdate = ?,del = ?,dailyentryid=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($clientpaymentreceiptt->clientid);
        $sqlQuery->setNumber($clientpaymentreceiptt->billid);
        $sqlQuery->setNumber($clientpaymentreceiptt->payedtype);
        $sqlQuery->setNumber($clientpaymentreceiptt->paymethod);
        $sqlQuery->set($clientpaymentreceiptt->debtbefore);
        $sqlQuery->set($clientpaymentreceiptt->payed);
        $sqlQuery->set($clientpaymentreceiptt->debtafter);
        $sqlQuery->set($clientpaymentreceiptt->biltype);
        $sqlQuery->setNumber($clientpaymentreceiptt->userid);
        $sqlQuery->set($clientpaymentreceiptt->sysdate);
        $sqlQuery->setNumber($clientpaymentreceiptt->del);
        $sqlQuery->setNumber($clientpaymentreceiptt->dailyentryid);

        $sqlQuery->setNumber($clientpaymentreceiptt->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM clientpaymentreceiptt';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayedtype($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE payedtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaymethod($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE paymethod = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtbefore($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE debtbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPayed($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtafter($value) {
        $sql = 'SELECT * FROM clientpaymentreceiptt WHERE debtafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayedtype($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE payedtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaymethod($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE paymethod = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtbefore($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE debtbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPayed($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE payed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtafter($value) {
        $sql = 'DELETE FROM clientpaymentreceiptt WHERE debtafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ClientpaymentreceipttMySql
     */
    protected function readRow($row) {
        $clientpaymentreceiptt = new Clientpaymentreceiptt();

        $clientpaymentreceiptt->id = isset($row['id']) ? $row['id'] : '';
        $clientpaymentreceiptt->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $clientpaymentreceiptt->billid = isset($row['billid']) ? $row['billid'] : '';
        $clientpaymentreceiptt->payedtype = isset($row['payedtype']) ? $row['payedtype'] : '';
        $clientpaymentreceiptt->paymethod = isset($row['paymethod']) ? $row['paymethod'] : '';
        $clientpaymentreceiptt->debtbefore = isset($row['debtbefore']) ? $row['debtbefore'] : '';
        $clientpaymentreceiptt->payed = isset($row['payed']) ? $row['payed'] : '';
        $clientpaymentreceiptt->debtafter = isset($row['debtafter']) ? $row['debtafter'] : '';
        $clientpaymentreceiptt->biltype = isset($row['biltype']) ? $row['biltype'] : '';
        $clientpaymentreceiptt->userid = isset($row['userid']) ? $row['userid'] : '';
        $clientpaymentreceiptt->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $clientpaymentreceiptt->del = isset($row['del']) ? $row['del'] : '';
        $clientpaymentreceiptt->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';

        return $clientpaymentreceiptt;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ClientpaymentreceipttMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>