<?php

/**
 * Class that operate on table 'clientdebtchange'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ClientdebtchangeMySqlDAO implements ClientdebtchangeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ClientdebtchangeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    public function load1($id) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangemodelid = ? ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM clientdebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM clientdebtchange ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param clientdebtchange primary key
     */
    public function delete($clientdebtchangeid) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($clientdebtchangeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ClientdebtchangeMySql clientdebtchange
     */
    public function insert($clientdebtchange) {
        $sql = 'INSERT INTO clientdebtchange (clientid, clientdebtchangebefore, clientdebtchangeamount, clientdebtchangetype, processname, clientdebtchangemodelid, clientdebtchangeafter, clientdebtchangedate, userid, tablename, comment, totalOperationCost,discount,reciptid,dailyentryid , num , billid , paytype, costcenterid,currencyId,conversionFactor,payedInCurrency,saveConversionFactor,userSelectedDate,paySerialNo ) VALUES (?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $clientdebtchange->currencyId = (empty($clientdebtchange->currencyId)) ? 1 : $clientdebtchange->currencyId;
        $clientdebtchange->conversionFactor = (empty($clientdebtchange->conversionFactor)) ? 1 : $clientdebtchange->conversionFactor;
        $clientdebtchange->payedInCurrency = (empty($clientdebtchange->payedInCurrency)) ? $clientdebtchange->clientdebtchangeamount : $clientdebtchange->payedInCurrency;
        $clientdebtchange->saveConversionFactor = (empty($clientdebtchange->saveConversionFactor)) ? 1 : $clientdebtchange->saveConversionFactor;
        //

        $sqlQuery->setNumber($clientdebtchange->clientid);
        $sqlQuery->set($clientdebtchange->clientdebtchangebefore);
        $sqlQuery->set($clientdebtchange->clientdebtchangeamount);
        $sqlQuery->setNumber($clientdebtchange->clientdebtchangetype);
        $sqlQuery->set($clientdebtchange->processname);
        $sqlQuery->setNumber($clientdebtchange->clientdebtchangemodelid);
        $sqlQuery->set($clientdebtchange->clientdebtchangeafter);
        $sqlQuery->set($clientdebtchange->clientdebtchangedate);
        $sqlQuery->setNumber($clientdebtchange->userid);
        $sqlQuery->set($clientdebtchange->tablename);
        $sqlQuery->setString2($clientdebtchange->comment);
        $sqlQuery->set((float) $clientdebtchange->totalOperationCost);
        $sqlQuery->set((float) $clientdebtchange->discount);
        $sqlQuery->setNumber($clientdebtchange->reciptid);
        $sqlQuery->setNumber($clientdebtchange->dailyentryid);
        $sqlQuery->setNumber($clientdebtchange->num);
        $sqlQuery->setNumber($clientdebtchange->billid);
        $sqlQuery->set($clientdebtchange->paytype);
        $sqlQuery->setNumber((int) $clientdebtchange->costcenterid);
        $sqlQuery->setNumber((int) $clientdebtchange->currencyId);
        $sqlQuery->setNumber((float) $clientdebtchange->conversionFactor);
        $sqlQuery->setNumber((float) $clientdebtchange->payedInCurrency);
        $sqlQuery->setNumber((float) $clientdebtchange->saveConversionFactor);
        $sqlQuery->set($clientdebtchange->userSelectedDate);
        $sqlQuery->setNumber((int) $clientdebtchange->paySerialNo);

        $id = $this->executeInsert($sqlQuery);
        $clientdebtchange->clientdebtchangeid = $id;
        return $id;
    }

    public function insert1($clientdebtchange) {
        $sql = 'INSERT INTO clientdebtchange (clientid, clientdebtchangebefore, clientdebtchangeamount, clientdebtchangetype, processname, clientdebtchangemodelid, clientdebtchangeafter, clientdebtchangedate, userid, tablename, comment, totalOperationCost,discount,reciptid, del,dailyentryid , num , billid ,paytype,seller,currencyId,conversionFactor,payedInCurrency,saveConversionFactor,userSelectedDate,paySerialNo) VALUES (?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($clientdebtchange->clientid);
        $sqlQuery->set($clientdebtchange->clientdebtchangebefore);
        $sqlQuery->set($clientdebtchange->clientdebtchangeamount);
        $sqlQuery->setNumber($clientdebtchange->clientdebtchangetype);
        $sqlQuery->set($clientdebtchange->processname);
        $sqlQuery->setNumber($clientdebtchange->clientdebtchangemodelid);
        $sqlQuery->set($clientdebtchange->clientdebtchangeafter);
        $sqlQuery->set($clientdebtchange->clientdebtchangedate);
        $sqlQuery->setNumber($clientdebtchange->userid);
        $sqlQuery->set($clientdebtchange->tablename);
        $sqlQuery->setString2($clientdebtchange->comment);
        $sqlQuery->set((float) $clientdebtchange->totalOperationCost);
        $sqlQuery->set((float) $clientdebtchange->discount);
        $sqlQuery->setNumber($clientdebtchange->reciptid);
        $sqlQuery->setNumber($clientdebtchange->del);
        $sqlQuery->setNumber($clientdebtchange->dailyentryid);
        $sqlQuery->setNumber($clientdebtchange->num);
        $sqlQuery->setNumber($clientdebtchange->billid);
        $sqlQuery->set($clientdebtchange->paytype);
        $sqlQuery->setNumber((int) $clientdebtchange->seller);
        $sqlQuery->setNumber((int) $clientdebtchange->currencyId);
        $sqlQuery->setNumber((float) $clientdebtchange->conversionFactor);
        $sqlQuery->setNumber((float) $clientdebtchange->payedInCurrency);
        $sqlQuery->setNumber((float) $clientdebtchange->saveConversionFactor);
        $sqlQuery->set($clientdebtchange->userSelectedDate);
        $sqlQuery->setNumber((int) $clientdebtchange->paySerialNo);


        $id = $this->executeInsert($sqlQuery);
        $clientdebtchange->clientdebtchangeid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ClientdebtchangeMySql clientdebtchange
     */
    public function update($clientdebtchange) {
        $sql = 'UPDATE clientdebtchange SET clientid = ?, clientdebtchangebefore = ?, clientdebtchangeamount = ?, clientdebtchangetype = ?, processname = ?, clientdebtchangemodelid = ?, clientdebtchangeafter = ?, clientdebtchangedate = ?, userid = ?, tablename = ?, comment = ?, totalOperationCost = ?,discount=?, reciptid=?, dailyentryid = ?,seller = ?,currencyId=?,conversionFactor=?,payedInCurrency=?,saveConversionFactor=? WHERE clientdebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($clientdebtchange->clientid);
        $sqlQuery->set($clientdebtchange->clientdebtchangebefore);
        $sqlQuery->set($clientdebtchange->clientdebtchangeamount);
        $sqlQuery->setNumber($clientdebtchange->clientdebtchangetype);
        $sqlQuery->set($clientdebtchange->processname);
        $sqlQuery->setNumber($clientdebtchange->clientdebtchangemodelid);
        $sqlQuery->set($clientdebtchange->clientdebtchangeafter);
        $sqlQuery->set($clientdebtchange->clientdebtchangedate);
        $sqlQuery->setNumber($clientdebtchange->userid);
        $sqlQuery->set($clientdebtchange->tablename);
        $sqlQuery->setString2($clientdebtchange->comment);
        $sqlQuery->set($clientdebtchange->totalOperationCost);
        $sqlQuery->set($clientdebtchange->discount);
        $sqlQuery->setNumber((int) $clientdebtchange->reciptid);
        $sqlQuery->setNumber((int) $clientdebtchange->dailyentryid);
        $sqlQuery->setNumber((int) $clientdebtchange->seller);
        $sqlQuery->setNumber((int) $clientdebtchange->currencyId);
        $sqlQuery->setNumber((float) $clientdebtchange->conversionFactor);
        $sqlQuery->setNumber((float) $clientdebtchange->payedInCurrency);
        $sqlQuery->setNumber((float) $clientdebtchange->saveConversionFactor);

        $sqlQuery->setNumber($clientdebtchange->clientdebtchangeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM clientdebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientdebtchangebefore($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebtchangeamount($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebtchangetype($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebtchangemodelid($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebtchangeafter($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebtchangedate($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE clientdebtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM clientdebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientdebtchangebefore($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebtchangeamount($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebtchangetype($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebtchangemodelid($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebtchangeafter($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebtchangedate($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE clientdebtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM clientdebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ClientdebtchangeMySql
     */
    protected function readRow($row) {
        $clientdebtchange = new Clientdebtchange();

        $clientdebtchange->clientdebtchangeid = isset($row['clientdebtchangeid']) ? $row['clientdebtchangeid'] : '';
        $clientdebtchange->clientdebtchangebefore = isset($row['clientdebtchangebefore']) ? $row['clientdebtchangebefore'] : '';
        $clientdebtchange->clientdebtchangeamount = isset($row['clientdebtchangeamount']) ? $row['clientdebtchangeamount'] : '';
        $clientdebtchange->clientdebtchangetype = isset($row['clientdebtchangetype']) ? $row['clientdebtchangetype'] : '';
        $clientdebtchange->processname = isset($row['processname']) ? $row['processname'] : '';
        $clientdebtchange->clientdebtchangemodelid = isset($row['clientdebtchangemodelid']) ? $row['clientdebtchangemodelid'] : '';
        $clientdebtchange->clientdebtchangeafter = isset($row['clientdebtchangeafter']) ? $row['clientdebtchangeafter'] : '';
        $clientdebtchange->clientdebtchangedate = isset($row['clientdebtchangedate']) ? $row['clientdebtchangedate'] : '';
        $clientdebtchange->userid = isset($row['userid']) ? $row['userid'] : '';
        $clientdebtchange->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $clientdebtchange->totalOperationCost = isset($row['totalOperationCost']) ? $row['totalOperationCost'] : '';
        $clientdebtchange->comment = isset($row['comment']) ? $row['comment'] : '';
        $clientdebtchange->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $clientdebtchange->conversionFactor = isset($row['conversionFactor']) ? $row['conversionFactor'] : '';
        $clientdebtchange->payedInCurrency = isset($row['payedInCurrency']) ? $row['payedInCurrency'] : '';
        $clientdebtchange->saveConversionFactor = isset($row['saveConversionFactor']) ? $row['saveConversionFactor'] : '';

        //required
        $clientdebtchange->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $clientdebtchange->clienttaxnumber = isset($row['clienttaxnumber']) ? $row['clienttaxnumber'] : '';
        $clientdebtchange->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $clientdebtchange->clientdebt = isset($row['clientdebt']) ? $row['clientdebt'] : '';
        $clientdebtchange->finalstring = isset($row['finalstring']) ? $row['finalstring'] : '';
        $clientdebtchange->discount = isset($row['discount']) ? $row['discount'] : '';
        $clientdebtchange->finishingPayedId = isset($row['finishingPayedId']) ? $row['finishingPayedId'] : '';
        $clientdebtchange->reciptid = isset($row['reciptid']) ? $row['reciptid'] : '';
        $clientdebtchange->discards = isset($row['discards']) ? $row['discards'] : '';
        $clientdebtchange->payedamount = isset($row['payedamount']) ? $row['payedamount'] : '';
        $clientdebtchange->del = isset($row['del']) ? $row['del'] : '';
        $clientdebtchange->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $clientdebtchange->seller = isset($row['seller']) ? $row['seller'] : '';
        $clientdebtchange->cliTotalDept = isset($row['cliTotalDept']) ? $row['cliTotalDept'] : '';
        $clientdebtchange->cliAmountDept = isset($row['cliAmountDept']) ? $row['cliAmountDept'] : '';
        $clientdebtchange->num = isset($row['num']) ? $row['num'] : '';
        $clientdebtchange->billid = isset($row['billid']) ? $row['billid'] : '';
        $clientdebtchange->paytype = isset($row['paytype']) ? $row['paytype'] : '';
        $clientdebtchange->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $clientdebtchange->savename = isset($row['savename']) ? $row['savename'] : '';
        $clientdebtchange->username = isset($row['username']) ? $row['username'] : '';
        $clientdebtchange->clientcode = isset($row['clientcode']) ? $row['clientcode'] : '';
        $clientdebtchange->clientmobile = isset($row['clientmobile']) ? $row['clientmobile'] : '';
        $clientdebtchange->clientaddress = isset($row['clientaddress']) ? $row['clientaddress'] : '';
        $clientdebtchange->mandobCollectRatio = isset($row['mandobCollectRatio']) ? $row['mandobCollectRatio'] : '';
        $clientdebtchange->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $clientdebtchange->userSelectedDate = isset($row['userSelectedDate']) ? $row['userSelectedDate'] : '';
        $clientdebtchange->paySerialNo = isset($row['paySerialNo']) ? $row['paySerialNo'] : '';
        $clientdebtchange->datedCheckeddone = isset($row['datedCheckeddone']) ? $row['datedCheckeddone'] : '';
        $clientdebtchange->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';

        return $clientdebtchange;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ClientdebtchangeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>