<?php

/**
 * Class that operate on table 'billtemplatedetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2022-05-25 03:14
 */
class BilltemplatedetailMySqlDAO implements BilltemplatedetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BilltemplatedetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billtemplatedetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billtemplatedetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billtemplatedetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billtemplatedetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BilltemplatedetailMySql billtemplatedetail
     */
    public function insert($billtemplatedetail) {
        $sql = 'INSERT INTO billtemplatedetail (billTemplateId, type, parcode, productid, sizeid, colorid, unitid, quantity) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billtemplatedetail->billTemplateId);
        $sqlQuery->setNumber($billtemplatedetail->type);
        $sqlQuery->set($billtemplatedetail->parcode);
        $sqlQuery->setNumber($billtemplatedetail->productid);
        $sqlQuery->setNumber($billtemplatedetail->sizeid);
        $sqlQuery->setNumber($billtemplatedetail->colorid);
        $sqlQuery->setNumber($billtemplatedetail->unitid);
        $sqlQuery->set($billtemplatedetail->quantity);

        $id = $this->executeInsert($sqlQuery);
        $billtemplatedetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BilltemplatedetailMySql billtemplatedetail
     */
    public function update($billtemplatedetail) {
        $sql = 'UPDATE billtemplatedetail SET billTemplateId = ?, type = ?, parcode = ?, productid = ?, sizeid = ?, colorid = ?, unitid = ?, quantity = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billtemplatedetail->billTemplateId);
        $sqlQuery->setNumber($billtemplatedetail->type);
        $sqlQuery->set($billtemplatedetail->parcode);
        $sqlQuery->setNumber($billtemplatedetail->productid);
        $sqlQuery->setNumber($billtemplatedetail->sizeid);
        $sqlQuery->setNumber($billtemplatedetail->colorid);
        $sqlQuery->setNumber($billtemplatedetail->unitid);
        $sqlQuery->set($billtemplatedetail->quantity);

        $sqlQuery->setNumber($billtemplatedetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billtemplatedetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillTemplateId($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE billTemplateId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySizeid($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByColorid($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitid($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM billtemplatedetail WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillTemplateId($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE billTemplateId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySizeid($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE sizeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByColorid($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE colorid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitid($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE unitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM billtemplatedetail WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BilltemplatedetailMySql
     */
    protected function readRow($row) {
        $billtemplatedetail = new Billtemplatedetail();

        $billtemplatedetail->id = $row['id'];
        $billtemplatedetail->billTemplateId = $row['billTemplateId'];
        $billtemplatedetail->type = $row['type'];
        $billtemplatedetail->parcode = $row['parcode'];
        $billtemplatedetail->productid = $row['productid'];
        $billtemplatedetail->sizeid = $row['sizeid'];
        $billtemplatedetail->colorid = $row['colorid'];
        $billtemplatedetail->unitid = $row['unitid'];
        $billtemplatedetail->quantity = $row['quantity'];
        //
        $billtemplatedetail->productName = $row['productName'];
        $billtemplatedetail->unitName = $row['unitName'];
        $billtemplatedetail->productCatName = $row['productCatName'];
        $billtemplatedetail->productCatId = $row['productCatId'];
        $billtemplatedetail->sizeName = $row['sizeName'];
        $billtemplatedetail->colorName = $row['colorName'];
        $billtemplatedetail->productnumber = $row['productnumber'];

        return $billtemplatedetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BilltemplatedetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>