<?php
/**
 * Class that operate on table 'availableparcode'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-02-04 15:18
 */
class AvailableparcodeMySqlDAO implements AvailableparcodeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return AvailableparcodeMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM availableparcode WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM availableparcode';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM availableparcode ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param availableparcode primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM availableparcode WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param AvailableparcodeMySql availableparcode
 	 */
	public function insert($availableparcode){
		$sql = 'INSERT INTO availableparcode (value) VALUES (?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($availableparcode->value);

		$id = $this->executeInsert($sqlQuery);	
		$availableparcode->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param AvailableparcodeMySql availableparcode
 	 */
	public function update($availableparcode){
		$sql = 'UPDATE availableparcode SET value = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($availableparcode->value);

		$sqlQuery->setNumber($availableparcode->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM availableparcode';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByValue($value){
		$sql = 'SELECT * FROM availableparcode WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByValue($value){
		$sql = 'DELETE FROM availableparcode WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return AvailableparcodeMySql 
	 */
	protected function readRow($row){
		$availableparcode = new Availableparcode();
		
		$availableparcode->id = $row['id'];
		$availableparcode->value = $row['value'];

		return $availableparcode;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return AvailableparcodeMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>