<?php

/**
 * Class that operate on table 'assetscat'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-07 10:32
 */
class AssetscatMySqlDAO implements AssetscatDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return AssetscatMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM assetscat WHERE assetscatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM assetscat';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM assetscat ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param assetscat primary key
     */
    public function delete($assetscatid) {
        $sql = 'DELETE FROM assetscat WHERE assetscatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($assetscatid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param AssetscatMySql assetscat
     */
    public function insert($assetscat, $Description) {
        $sql = 'INSERT INTO assetscat (cattitel,descripe, userid, assetscatdate, del,treeId) VALUES (?, ?,?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($assetscat->cattitel);
        $sqlQuery->setString2($Description);
        $sqlQuery->setNumber($assetscat->userid);
        $sqlQuery->set($assetscat->assetscatdate);
        $sqlQuery->setNumber($assetscat->del);
        $sqlQuery->setNumber((int) $assetscat->treeId);

        $id = $this->executeInsert($sqlQuery);
        $assetscat->assetscatid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param AssetscatMySql assetscat
     */
    public function update($assetscat, $description) {
        $sql = 'UPDATE assetscat SET cattitel = ?,descripe=? , userid = ?, assetscatdate = ?, del = ?,treeId=? WHERE assetscatid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($assetscat->cattitel);
        $sqlQuery->setString2($description);
        $sqlQuery->setNumber($assetscat->userid);
        $sqlQuery->set($assetscat->assetscatdate);
        $sqlQuery->setNumber($assetscat->del);
        $sqlQuery->setNumber((int) $assetscat->treeId);

        $sqlQuery->setNumber($assetscat->assetscatid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM assetscat';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCattitel($value) {
        $sql = 'SELECT * FROM assetscat WHERE cattitel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM assetscat WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetscatdate($value) {
        $sql = 'SELECT * FROM assetscat WHERE assetscatdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM assetscat WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCattitel($value) {
        $sql = 'DELETE FROM assetscat WHERE cattitel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM assetscat WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetscatdate($value) {
        $sql = 'DELETE FROM assetscat WHERE assetscatdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM assetscat WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return AssetscatMySql
     */
    protected function readRow($row) {
        $assetscat = new Assetscat();

        $assetscat->assetscatid = isset($row['assetscatid']) ? $row['assetscatid'] : '';
        $assetscat->cattitel = isset($row['cattitel']) ? $row['cattitel'] : '';
        $assetscat->userid = isset($row['userid']) ? $row['userid'] : '';
        $assetscat->assetscatdate = isset($row['assetscatdate']) ? $row['assetscatdate'] : '';
        $assetscat->del = isset($row['del']) ? $row['del'] : '';
        $assetscat->descripe = isset($row['descripe']) ? $row['descripe'] : '';
        //
        $assetscat->treeId = isset($row['treeId']) ? $row['treeId'] : '';



        return $assetscat;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return AssetscatMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>