<?php

/**
 * Class that operate on table 'assets'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class AssetsMySqlDAO implements AssetsDAO
{

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return AssetsMySql
     */
    public function load($id)
    {
        $sql = 'SELECT * FROM assets WHERE assetId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll()
    {
        $sql = 'SELECT * FROM assets';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn)
    {
        $sql = 'SELECT * FROM assets ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param asset primary key
     */
    public function delete($assetId)
    {
        $sql = 'DELETE FROM assets WHERE assetId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($assetId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param AssetsMySql asset
     */
    public function insert($asset, $assetDescription)
    {
        $sql = 'INSERT INTO assets (assetsName, assetsDescription, assetsValue, assetsDate,depreciation, conditions, userid,type,assetsDepreciation,assetscatid,manufacture,Hourlyrate, dailyentryid, saveid,treeId,paytype,supplierid) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,? ,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($asset->assetsName);
        $sqlQuery->setString2($assetDescription);
        $sqlQuery->set($asset->assetsValue);

        $sqlQuery->set($asset->assetsDate);
        $sqlQuery->set($asset->depreciation);

        $sqlQuery->setNumber($asset->conditions);
        $sqlQuery->setNumber($asset->userid);
        $sqlQuery->setNumber($asset->type);
        $sqlQuery->set($asset->assetsDepreciation);
        $sqlQuery->set($asset->assetscatid);
        $sqlQuery->setNumber($asset->manufacture);
        $sqlQuery->set($asset->Hourlyrate);
        $sqlQuery->set($asset->dailyentryid);
        $sqlQuery->setNumber($asset->saveid);
        $sqlQuery->setNumber((int) $asset->treeId);
        $sqlQuery->setNumber($asset->paytype);
        $sqlQuery->setNumber($asset->supplierid);

        $id = $this->executeInsert($sqlQuery);
        $asset->assetId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param AssetsMySql asset
     */
    public function update($asset, $assetDescription)
    {
        $sql = 'UPDATE assets SET assetsName = ?, assetsDescription=?, assetsValue = ?, assetsDate = ?,depreciation=?, conditions = ?, userid = ? ,type=?, assetsDepreciation = ? ,assetscatid =? ,manufacture =? ,Hourlyrate = ?, dailyentryid = ?, saveid = ?,treeId=?, paytype = ?, supplierid = ? WHERE assetId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($asset->assetsName);
        $sqlQuery->setString2($assetDescription);
        $sqlQuery->set($asset->assetsValue);

        $sqlQuery->set($asset->assetsDate);
        $sqlQuery->set($asset->depreciation);

        $sqlQuery->setNumber($asset->conditions);
        $sqlQuery->setNumber($asset->userid);
        $sqlQuery->setNumber($asset->type);
        $sqlQuery->set($asset->assetsDepreciation);
        $sqlQuery->set($asset->assetscatid);
        $sqlQuery->setNumber($asset->manufacture);
        $sqlQuery->set($asset->Hourlyrate);
        $sqlQuery->set($asset->dailyentryid);
        $sqlQuery->setNumber($asset->saveid);
        $sqlQuery->setNumber((int) $asset->treeId);
        $sqlQuery->setNumber($asset->paytype);
        $sqlQuery->setNumber($asset->supplierid);

        $sqlQuery->setNumber($asset->assetId);

        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean()
    {
        $sql = 'DELETE FROM assets';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByAssetsName($value)
    {
        $sql = 'SELECT * FROM assets WHERE assetsName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetsDescription($value)
    {
        $sql = 'SELECT * FROM assets WHERE assetsDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetsValue($value)
    {
        $sql = 'SELECT * FROM assets WHERE assetsValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetsDepreciation($value)
    {
        $sql = 'SELECT * FROM assets WHERE assetsDepreciation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetsDate($value)
    {
        $sql = 'SELECT * FROM assets WHERE assetsDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value)
    {
        $sql = 'SELECT * FROM assets WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value)
    {
        $sql = 'SELECT * FROM assets WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByAssetsName($value)
    {
        $sql = 'DELETE FROM assets WHERE assetsName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetsDescription($value)
    {
        $sql = 'DELETE FROM assets WHERE assetsDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetsValue($value)
    {
        $sql = 'DELETE FROM assets WHERE assetsValue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetsDepreciation($value)
    {
        $sql = 'DELETE FROM assets WHERE assetsDepreciation = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetsDate($value)
    {
        $sql = 'DELETE FROM assets WHERE assetsDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value)
    {
        $sql = 'DELETE FROM assets WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value)
    {
        $sql = 'DELETE FROM assets WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return AssetsMySql
     */
    protected function readRow($row)
    {
        $asset = new Asset();

        $asset->assetId = isset($row['assetId']) ? $row['assetId'] : '';
        $asset->assetsName = isset($row['assetsName']) ? $row['assetsName'] : '';

        $asset->assetsValue = isset($row['assetsValue']) ? $row['assetsValue'] : '';
        $asset->assetsDepreciation = isset($row['assetsDepreciation']) ? $row['assetsDepreciation'] : '';
        $asset->assetsDate = isset($row['assetsDate']) ? $row['assetsDate'] : '';
        $asset->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $asset->userid = isset($row['userid']) ? $row['userid'] : '';
        $asset->depreciation = isset($row['depreciation']) ? $row['depreciation'] : '';
        $asset->assetscatid = isset($row['assetscatid']) ? $row['assetscatid'] : '';
        $asset->assetsDescription = isset($row['assetsDescription']) ? $row['assetsDescription'] : '';
        $asset->type = isset($row['type']) ? $row['type'] : '';
        $asset->manufacture = isset($row['manufacture']) ? $row['manufacture'] : '';
        $asset->Hourlyrate = isset($row['Hourlyrate']) ? $row['Hourlyrate'] : '';

        //required
        $asset->sumasset = isset($row['sumasset']) ? $row['sumasset'] : '';
        $asset->cattitel = isset($row['cattitel']) ? $row['cattitel'] : '';
        $asset->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $asset->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $asset->treeId = isset($row['treeId']) ? $row['treeId'] : '';
        $asset->paytype = isset($row['paytype']) ? $row['paytype'] : '';
        $asset->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $asset->assetssaleid = isset($row['assetssaleid']) ? $row['assetssaleid'] : '';

        return $asset;
    }

    protected function getList($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return AssetsMySql
     */
    protected function getRow($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery)
    {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery)
    {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery)
    {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery)
    {
        return QueryExecutor::executeInsert($sqlQuery);
    }
}
