<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-09-05 04:21
 */
interface TypesimpotencetreatmentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Typesimpotencetreatment 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param typesimpotencetreatment primary key
 	 */
	public function delete($typesimpotencetreatmentid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Typesimpotencetreatment typesimpotencetreatment
 	 */
	public function insert($typesimpotencetreatment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Typesimpotencetreatment typesimpotencetreatment
 	 */
	public function update($typesimpotencetreatment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTypesimpotencetreatmentname($value);

	public function queryByTypesimpotencetreatmentdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByTypesimpotencetreatmentcomment($value);


	public function deleteByTypesimpotencetreatmentname($value);

	public function deleteByTypesimpotencetreatmentdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByTypesimpotencetreatmentcomment($value);


}
?>