<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-07-20 15:34
 */
interface SupplieropenDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Supplieropen 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param supplieropen primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Supplieropen supplieropen
 	 */
	public function insert($supplieropen);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Supplieropen supplieropen
 	 */
	public function update($supplieropen);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByValue($value);

	public function queryByTreeId($value);

	public function queryByDailyentryid($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByValue($value);

	public function deleteByTreeId($value);

	public function deleteByDailyentryid($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>