<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 15:22
 */
interface SparepartstorereportDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sparepartstorereport 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sparepartstorereport primary key
 	 */
	public function delete($sparepartstorereportid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sparepartstorereport sparepartstorereport
 	 */
	public function insert($sparepartstorereport);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sparepartstorereport sparepartstorereport
 	 */
	public function update($sparepartstorereport);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySparepartid($value);

	public function queryBySparepartstoreId($value);

	public function queryByPartquantity($value);

	public function queryByStorereporttype($value);

	public function queryByStorereportmodelid($value);

	public function queryByProcessname($value);

	public function queryByTablename($value);

	public function queryByPartbefore($value);

	public function queryByPartafter($value);

	public function queryByUserid($value);

	public function queryByStorereportdate($value);


	public function deleteBySparepartid($value);

	public function deleteBySparepartstoreId($value);

	public function deleteByPartquantity($value);

	public function deleteByStorereporttype($value);

	public function deleteByStorereportmodelid($value);

	public function deleteByProcessname($value);

	public function deleteByTablename($value);

	public function deleteByPartbefore($value);

	public function deleteByPartafter($value);

	public function deleteByUserid($value);

	public function deleteByStorereportdate($value);


}
?>