<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-08-24 15:24
 */
interface SellbilldetailofferDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sellbilldetailoffer 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sellbilldetailoffer primary key
 	 */
	public function delete($sellbilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sellbilldetailoffer sellbilldetailoffer
 	 */
	public function insert($sellbilldetailoffer);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sellbilldetailoffer sellbilldetailoffer
 	 */
	public function update($sellbilldetailoffer);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuyprice($value);

	public function queryByParcode($value);

	public function queryBySellbillid($value);

	public function queryBySellbilldetailcatid($value);

	public function queryBySellbilldetailproductid($value);

	public function queryBySellbilldetailquantity($value);

	public function queryBySellbilldetailprice($value);

	public function queryBySellbilldetailtotalprice($value);

	public function queryByDiscountvalue($value);

	public function queryByNote($value);

	public function queryByPricetype($value);

	public function queryBySellbilldetaildate($value);

	public function queryByProductunitid($value);

	public function queryByBuydiscount($value);

	public function queryByBuydiscounttype($value);

	public function queryByStoreid($value);

	public function queryByDiscounttype($value);

	public function queryByLocaldonw($value);

	public function queryByLastbuyprice($value);

	public function queryByMeanbuyprice($value);

	public function queryByLastbuypriceWithDiscount($value);

	public function queryByMeanbuypriceWithDiscount($value);

	public function queryByScunitqty($value);

	public function queryByOtherdetailquantity($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByOnlineOrderId($value);

	public function queryByPricetypepro($value);


	public function deleteByBuyprice($value);

	public function deleteByParcode($value);

	public function deleteBySellbillid($value);

	public function deleteBySellbilldetailcatid($value);

	public function deleteBySellbilldetailproductid($value);

	public function deleteBySellbilldetailquantity($value);

	public function deleteBySellbilldetailprice($value);

	public function deleteBySellbilldetailtotalprice($value);

	public function deleteByDiscountvalue($value);

	public function deleteByNote($value);

	public function deleteByPricetype($value);

	public function deleteBySellbilldetaildate($value);

	public function deleteByProductunitid($value);

	public function deleteByBuydiscount($value);

	public function deleteByBuydiscounttype($value);

	public function deleteByStoreid($value);

	public function deleteByDiscounttype($value);

	public function deleteByLocaldonw($value);

	public function deleteByLastbuyprice($value);

	public function deleteByMeanbuyprice($value);

	public function deleteByLastbuypriceWithDiscount($value);

	public function deleteByMeanbuypriceWithDiscount($value);

	public function deleteByScunitqty($value);

	public function deleteByOtherdetailquantity($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByOnlineOrderId($value);

	public function deleteByPricetypepro($value);


}
?>