<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-03-09 11:49
 */
interface SalaryreportDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Salaryreport 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param salaryreport primary key
 	 */
	public function delete($salaryreportid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Salaryreport salaryreport
 	 */
	public function insert($salaryreport);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Salaryreport salaryreport
 	 */
	public function update($salaryreport);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployeeid($value);

	public function queryBySalaryreportdate($value);

	public function queryByUserid($value);

	public function queryBySalaryreportsalary($value);

	public function queryBySalaryreportdiscount($value);

	public function queryBySalaryreportbouns($value);

	public function queryBySalaryreportwithdrawal($value);

	public function queryBySalaryreportnet($value);

	public function queryBySalarymonthdate($value);


	public function deleteByEmployeeid($value);

	public function deleteBySalaryreportdate($value);

	public function deleteByUserid($value);

	public function deleteBySalaryreportsalary($value);

	public function deleteBySalaryreportdiscount($value);

	public function deleteBySalaryreportbouns($value);

	public function deleteBySalaryreportwithdrawal($value);

	public function deleteBySalaryreportnet($value);

	public function deleteBySalarymonthdate($value);


}
?>