<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:06
 */
interface RentstoreDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rentstore 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rentstore primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rentstore rentstore
 	 */
	public function insert($rentstore);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rentstore rentstore
 	 */
	public function update($rentstore);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRentproductid($value);

	public function queryByAmount($value);

	public function queryByRented($value);


	public function deleteByRentproductid($value);

	public function deleteByAmount($value);

	public function deleteByRented($value);


}
?>