<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-03 12:01
 */
interface ProjectexchmaterialdetailreturnDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Projectexchmaterialdetailreturn 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param projectexchmaterialdetailreturn primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Projectexchmaterialdetailreturn projectexchmaterialdetailreturn
 	 */
	public function insert($projectexchmaterialdetailreturn);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Projectexchmaterialdetailreturn projectexchmaterialdetailreturn
 	 */
	public function update($projectexchmaterialdetailreturn);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProjectexchid($value);

	public function queryByProductid($value);

	public function queryByPronumber($value);


	public function deleteByProjectexchid($value);

	public function deleteByProductid($value);

	public function deleteByPronumber($value);


}
?>