<?php

/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-02-17 01:28
 */
interface MaccontrolDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @Return Maccontrol
     */
    public function load($id);

    /**
     * Get all records from table
     */
    public function queryAll();

    /**
     * Get all records from table ordered by field
     * @Param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn);

    /**
     * Delete record from table
     * @param maccontrol primary key
     */
    public function delete($id);

    /**
     * Insert record to table
     *
     * @param Maccontrol maccontrol
     */
    public function insert($maccontrol);

    /**
     * Update record in table
     *
     * @param Maccontrol maccontrol
     */
    public function update($maccontrol);

    /**
     * Delete all rows
     */
    public function clean();

    public function queryByMac($value);

    public function queryByDeviceType($value);

    public function queryByAllowRemoteAccess($value);

    public function queryByUserid($value);

    public function queryByDel($value);

    public function queryBySysdate($value);
    
   
    
    public function deleteByMac($value);

    public function deleteByDeviceType($value);

    public function deleteByAllowRemoteAccess($value);

    public function deleteByUserid($value);

    public function deleteByDel($value);

    public function deleteBySysdate($value);
}

?>