<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MFinishingpayedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MFinishingpayed 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mFinishingpayed primary key
 	 */
	public function delete($finishingPayedId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MFinishingpayed mFinishingpayed
 	 */
	public function insert($mFinishingpayed);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MFinishingpayed mFinishingpayed
 	 */
	public function update($mFinishingpayed);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientId($value);

	public function queryByPayed($value);

	public function queryByClientDebtChangeId($value);

	public function queryByFinishingType($value);

	public function queryByFinishingPayedDate($value);

	public function queryByRemain($value);

	public function queryByUserId($value);

	public function queryByBranchId($value);

	public function queryByDel($value);


	public function deleteByClientId($value);

	public function deleteByPayed($value);

	public function deleteByClientDebtChangeId($value);

	public function deleteByFinishingType($value);

	public function deleteByFinishingPayedDate($value);

	public function deleteByRemain($value);

	public function deleteByUserId($value);

	public function deleteByBranchId($value);

	public function deleteByDel($value);


}
?>