<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
interface DoctorkashfDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Doctorkashf 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param doctorkashf primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Doctorkashf doctorkashf
 	 */
	public function insert($doctorkashf);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Doctorkashf doctorkashf
 	 */
	public function update($doctorkashf);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRdsphere($value);

	public function queryByRnsphere($value);

	public function queryByRdcylinder($value);

	public function queryByRncylinder($value);

	public function queryByRdaxis($value);

	public function queryByRnaxis($value);

	public function queryByRdprism($value);

	public function queryByRnprism($value);

	public function queryByRdva($value);

	public function queryByRnva($value);

	public function queryByLdsphere($value);

	public function queryByLnsphere($value);

	public function queryByLdcylinder($value);

	public function queryByLncylinder($value);

	public function queryByLdaxis($value);

	public function queryByLnaxis($value);

	public function queryByLdprism($value);

	public function queryByLnprism($value);

	public function queryByLdva($value);

	public function queryByLnva($value);

	public function queryByCustomerid($value);

	public function queryByKashfid($value);


	public function deleteByRdsphere($value);

	public function deleteByRnsphere($value);

	public function deleteByRdcylinder($value);

	public function deleteByRncylinder($value);

	public function deleteByRdaxis($value);

	public function deleteByRnaxis($value);

	public function deleteByRdprism($value);

	public function deleteByRnprism($value);

	public function deleteByRdva($value);

	public function deleteByRnva($value);

	public function deleteByLdsphere($value);

	public function deleteByLnsphere($value);

	public function deleteByLdcylinder($value);

	public function deleteByLncylinder($value);

	public function deleteByLdaxis($value);

	public function deleteByLnaxis($value);

	public function deleteByLdprism($value);

	public function deleteByLnprism($value);

	public function deleteByLdva($value);

	public function deleteByLnva($value);

	public function deleteByCustomerid($value);

	public function deleteByKashfid($value);


}
?>