<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-01-05 22:09
 */
interface BuybillofferDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buybilloffer 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buybilloffer primary key
 	 */
	public function delete($buybillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buybilloffer buybilloffer
 	 */
	public function insert($buybilloffer);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buybilloffer buybilloffer
 	 */
	public function update($buybilloffer);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuybillSerial($value);

	public function queryByBuybilldate($value);

	public function queryByBuybillsupplierid($value);

	public function queryByBuybilltotaldeptbefor($value);

	public function queryByBuybilltotaldeptafter($value);

	public function queryByBuybilldiscount($value);

	public function queryByBuybilldiscountrype($value);

	public function queryByBuybilltotalbill($value);

	public function queryByBuybillaftertotalbill($value);

	public function queryByBuybilltotalpayed($value);

	public function queryByBuybillfinalbill($value);

	public function queryByBuybillstoreid($value);

	public function queryByBuybillsysdate($value);

	public function queryByComment($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByBuybillclientname($value);

	public function queryByBuybillsaveid($value);

	public function queryByBuybilldirectpayment($value);

	public function queryByBillnameid($value);

	public function queryByDeletedbuyid($value);

	public function queryByControlname($value);

	public function queryByPayedtax($value);

	public function queryByCostcenterid($value);

	public function queryByDailyentryid($value);

	public function queryByDelbyuserid($value);

	public function queryByCurrencyId($value);


	public function deleteByBuybillSerial($value);

	public function deleteByBuybilldate($value);

	public function deleteByBuybillsupplierid($value);

	public function deleteByBuybilltotaldeptbefor($value);

	public function deleteByBuybilltotaldeptafter($value);

	public function deleteByBuybilldiscount($value);

	public function deleteByBuybilldiscountrype($value);

	public function deleteByBuybilltotalbill($value);

	public function deleteByBuybillaftertotalbill($value);

	public function deleteByBuybilltotalpayed($value);

	public function deleteByBuybillfinalbill($value);

	public function deleteByBuybillstoreid($value);

	public function deleteByBuybillsysdate($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByBuybillclientname($value);

	public function deleteByBuybillsaveid($value);

	public function deleteByBuybilldirectpayment($value);

	public function deleteByBillnameid($value);

	public function deleteByDeletedbuyid($value);

	public function deleteByControlname($value);

	public function deleteByPayedtax($value);

	public function deleteByCostcenterid($value);

	public function deleteByDailyentryid($value);

	public function deleteByDelbyuserid($value);

	public function deleteByCurrencyId($value);


}
?>