<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BillsettingsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billsettings 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billsetting primary key
 	 */
	public function delete($billsettingsid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billsettings billsetting
 	 */
	public function insert($billsetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billsettings billsetting
 	 */
	public function update($billsetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillnameid($value,$proprtyid);

	public function queryByBillpropertyid($value);

	public function queryByBillsettingsvalue($value);


	public function deleteByBillnameid($value);

	public function deleteByBillpropertyid($value);

	public function deleteByBillsettingsvalue($value);


}
?>